<?php
/**
* Copyright (c) Xerox Corporation, Codendi Team, 2001-2007. All rights reserved
*
* 
*/

require_once(CODENDI_CLI_DIR.'/CLI_Action.class.php');

class CLI_Action_Tracker_Reports extends CLI_Action {
    function CLI_Action_Tracker_Reports() {
        $this->CLI_Action('reports', 'Returns the list of reports associated with a specific tracker.');
        $this->soapCommand = 'getArtifactReports';
        $this->addParam(array(
            'name'           => 'group_artifact_id',
            'description'    => '--tracker_id=<tracker_id>    The ID of the tracker the returned artifact reports belong to.',
            'parameters'     => array('tracker_id'),
        ));
    }
    function validate_group_artifact_id(&$group_artifact_id) {
        if (!$group_artifact_id) {
            exit_error("You must specify a tracker ID using the --tracker_id parameter");
        }
        return true;
    }
}

?>